require 'benchmark'

def rest_method(*arr)
end

def lead_method(first, *arr)
end

def post_method(*arr, last)
end

def lead_post_method(first, *arr, last)
end

def benchmark_method(a, b, c, d, e)
end

def final_method(a, b, c, d, e)
  a + b + c + d + e
end

def rest_with_named_parameter(*arr, ignore:)
end

bench_proc = proc{|a,b,c,d,e| }
lead_proc = proc{|a,b,c,d,*rest| }
opt_post_proc = proc{|a,b,c=-1,d=-1, e,f| }
# lead_proc = proc{|a,b,c,d,*rest| a + b + c + a + b + c}
# opt_post_proc = proc{|a,b,c=-1,d=-1, e,f| a + b + c + d + e + f}


N = 3_000_000

param_1_to_5_with_hash = [1,2,3,4,5, ignore: 1]
param_1_to_3 = [1,2,3]
param_1_to_7 = [1,2,3,4,5,6,7]
param_1_to_5 = [1,2,3,4,5]
param_1_to_100 = (1..100).to_a

Benchmark.bmbm do |b|
  b.report('benchmark_method') { N.times{ benchmark_method 1,2,3,4,5 } }
  b.report('rest_method') { N.times{ rest_method 1,2,3,4,5 } }
  b.report('lead_method') { N.times{ lead_method 1,2,3,4,5 } }
  b.report('post_method') { N.times{ post_method 1,2,3,4,5 } }
  b.report('lead_post_method') { N.times{ lead_post_method 1,2,3,4,5 } }
  b.report('benchmark_method *args') { N.times{ benchmark_method *param_1_to_5 } }
  b.report('rest_method *args') { N.times{ rest_method *param_1_to_5 } }
  b.report('lead_method *args') { N.times{ lead_method *param_1_to_5 } }
  b.report('post_method *args') { N.times{ post_method *param_1_to_5 } }
  b.report('lead_post_method *args') { N.times{ lead_post_method *param_1_to_5 } }
  b.report('rest_method *long_args') { N.times{ rest_method *param_1_to_100 } }
  b.report('lead_method *long_args') { N.times{ lead_method *param_1_to_100 } }
  b.report('post_method *long_args') { N.times{ post_method *param_1_to_100 } }
  b.report('lead_post_method *long_args') { N.times{ lead_post_method *param_1_to_100 } }
  b.report('rest_with_named_parameter') { N.times{ rest_with_named_parameter *param_1_to_5_with_hash } }
  b.report('bench proc') { N.times{ bench_proc.call *param_1_to_5 } }
  b.report('lead_proc underflow_args') { N.times{ lead_proc.call *param_1_to_3 } }
  b.report('opt_post_proc overflow_args') { N.times{ opt_post_proc.call *param_1_to_7 } }
end

def object_info(trace: Array)
  GC.disable
  obj_ids = []
  final_ids = []
  obj_sps = ObjectSpace.each_object(trace)
  obj_sps.each{|i|obj_ids << i.__id__ }
  obj_ids << obj_ids.__id__
  yield
  obj_sps.each{|i|final_ids << i.__id__ }
  ref =  (final_ids - obj_ids).collect{|i| ObjectSpace._id2ref(i)}
  GC.start
  ref
end



puts object_info{ benchmark_method 1,2,3,4,5 }.size
puts object_info{ rest_method 1,2,3,4,5 }.size
puts object_info{ lead_method 1,2,3,4,5 }.size
puts object_info{ post_method 1,2,3,4,5 }.size
puts object_info{ lead_post_method 1,2,3,4,5 }.size
puts object_info{ benchmark_method *param_1_to_5 }.size
puts object_info{ rest_method *param_1_to_5 }.size
puts object_info{ lead_method *param_1_to_5 }.size
puts object_info{ post_method *param_1_to_5 }.size
puts object_info{ lead_post_method *param_1_to_5 }.size
puts object_info{ rest_with_named_parameter *param_1_to_5_with_hash }.size
puts object_info{ bench_proc.call *param_1_to_5 }.size
puts object_info{ lead_proc.call *param_1_to_3 }.size
puts object_info{ opt_post_proc.call *param_1_to_7 }.size

