#define FUSE_USE_VERSION 30

#include <fuse.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>

static void sleep_for(int s) {
	printf("\tsleep ");
	for (int i = 0; i < s; ++i) {
		printf(".");
		sleep(1);
	}
	printf("\n");
}

static int do_getattr(const char *path, struct stat *st) {
	printf("[getattr] Called\n");
	printf("\tAttributes of %s requested\n", path);

	sleep_for(30);

	st->st_uid = getuid();
	st->st_gid = getgid();
	st->st_atime = time(NULL);
	st->st_mtime = time(NULL);

	if (strcmp(path, "/") == 0) {
		st->st_mode = S_IFDIR | 0755;
		st->st_nlink = 2;
	} else {
		st->st_mode = S_IFREG | 0644;
		st->st_nlink = 1;
		st->st_size = 1024;
	}

	return 0;
}

static int do_readdir(
	const char *path,
	void *buffer,
	fuse_fill_dir_t filler,
	off_t offset,
	struct fuse_file_info *fi
) {
	printf("[readdir] Called\n");
	printf("\tGetting The List of Files of %s\n", path);

	sleep_for(30);

	filler(buffer, ".", NULL, 0); // Current Directory
	filler(buffer, "..", NULL, 0); // Parent Directory

	// If the user is trying to show the files/directories of the root
	// directory show the following
	if (strcmp(path, "/") == 0) {
		filler(buffer, "file54", NULL, 0);
		filler(buffer, "file349", NULL, 0);
	}

	return 0;
}

static int do_read(
	const char *path,
	char *buffer,
	size_t size,
	off_t offset,
	struct fuse_file_info *fi
) {
	printf("[read] Called\n");
	printf("\tGetting The Content of %s, size: %zu, off: %zu \n", path, size, offset);

	sleep_for(30);

	char file54Text[] = "Hello World From File54!";
	char file349Text[] = "Hello World From File349!";
	char *selectedText = NULL;

	if ( strcmp( path, "/file54" ) == 0 ) {
		selectedText = file54Text;
	} else if ( strcmp( path, "/file349" ) == 0 ) {
		selectedText = file349Text;
	} else {
		return -1;
	}

	memcpy(buffer, selectedText + offset, size);

	return strlen(selectedText) - offset;
}

static struct fuse_operations operations = {
	.getattr = do_getattr,
	.readdir = do_readdir,
	.read    = do_read,
};

int main(int argc, char *argv[]) {
	setbuf(stdout, NULL);

	return fuse_main(argc, argv, &operations, NULL);
}
