require 'benchmark'

type = ARGV[0]
memory_size = 200
obj_num = 2000

case type
when /^m/
  print "malloc "
  10.times do |i|
    print "."
    " " * (1024 * 1024 * memory_size)
  end
else
  print "realloc "
  10.times do |i|
    print "."
    a = []
    (memory_size*1024).times do
      a[1024] = nil
      a.clear
    end
  end
end

puts " start benchmark", ""
GC::Profiler.enable

Benchmark.bm do |bm|
  bm.report do
    obj_num.times do
      " " * (1024*1024)
    end
  end
end

puts "", GC::Profiler.result[/.+\n/]
