#!/usr/bin/ruby1.9.1 -d -I.

require 'gettext'
include GetText

$SAFE = 1

set_current_locale ARGV[0]
bindtextdomain('test', :path => './')

module Locale
  module_function
  def require_driver(name)  #:nodoc:
    require File.join(ROOT, "locale/driver", name.to_s).untaint
  end
end

module GetText
  class MOFile
  alias :oldload :load
    def load(arg)
      arg = arg.dup.untaint if arg.kind_of? String
      oldload(arg)
    end
  end
end

puts _('Hello world!')


