#!/bin/bash

PID=$1

cat > /tmp/dtracetmp.$$ <<EOF
#!/usr/sbin/dtrace -s

#pragma D option bufsize=16m
#pragma D option dynvarsize=16m
#pragma D option cleanrate=50Hz

BEGIN {
  printf("Ready! (Go press enter on the original script.)\n");
}

ruby${PID}:::gc-mark-begin {
  self->mark_begin = timestamp;
}

ruby${PID}:::gc-mark-end /self->mark_begin/ {
  elapsed = timestamp - self->mark_begin;
  @mark_total = sum(elapsed);
  @total = sum(elapsed);
  self->mark_begin = 0;
}

ruby${PID}:::gc-sweep-begin {
  self->sweep_begin = timestamp;
}

ruby${PID}:::gc-sweep-end /self->sweep_begin/ {
  elapsed = timestamp - self->sweep_begin;
  @sweep_total = sum(elapsed);
  @total = sum(elapsed);
  self->sweep_begin = 0;
}

END {
  normalize(@mark_total,  1000000);
  normalize(@sweep_total, 1000000);
  normalize(@total,       1000000);
  printa("Mark total:         %@d ms\n", @mark_total);
  printa("Sweep total:        %@d ms\n", @sweep_total);
  printa("Mark + sweep total: %@d ms\n", @total)
}

EOF

dtrace -q -s /tmp/dtracetmp.$$ -p $PID
