require 'Win32API'

class Watcher
  OpenProcess         = Win32API.new('kernel32', 'OpenProcess', 'LIL', 'L')
  WaitForSingleObject = Win32API.new('kernel32', 'WaitForSingleObject', 'LL', 'L')

  SYNCHRONIZE   = 0x100000
  WAIT_OBJECT_0 = 0
  TIMEOUT       = 10 * 60 * 1000 # 10mins

  attr_reader :pid

  def initialize(io)
    @pid = io.gets.chomp.to_i
    @timeout = io.gets.chomp.to_i
    @info = io.gets.chomp
  end

  def waitpid
    handle = OpenProcess.call(SYNCHRONIZE, 0, pid)
    WaitForSingleObject.call(handle, TIMEOUT)
  end

  def execute
    case waitpid
    when WAIT_OBJECT_0
      $stderr.puts("Process #{@pid} completed")
    else
      $stderr.puts("Failed to wait for #{@pid}")
    end
  end
end

if __FILE__ == $0
  watcher = Watcher.new($stdin)
  watcher.execute
end
