# Encoding: UTF-8

expected_encoding = Encoding::CP850
path = ARGV[0]

if path == nil or path.encoding != expected_encoding
    puts "Please pass me a #{expected_encoding.name} file path to an existing file."
    exit
end

puts "Path encoding is #{path.encoding} and is #{path.valid_encoding? ? "valid" : "invalid"}."

begin
    puts "Here is content of #{path}:"
    puts File.readlines(path)
rescue Exception => e
    puts "I could not open #{path}"
end

puts
puts "So... we must encode the path into its very own encoding, and from a different encoding???"
puts "It's just like path.encoding is lying and we need to fix it!"
puts "    new_path = path.encode(path.encoding, \"ISO-8859-1\")"
puts

begin
    new_path = path.encode(path.encoding, "ISO-8859-1")
    puts "Here is content of #{new_path}:"
    puts File.readlines(new_path)
rescue Exception => e
    puts "I could not open #{new_path}, this should not have happened."
    puts "Please replace 'ISO-8859-1' in source file with your best bet for the 'actual' encoding."
end
