# Encoding: UTF-8

if ARGV[0] == nil or ARGV[0].encoding != Encoding::CP850
    puts "Please run me from cmd.exe after \"chcp 850\", and pass me"
    puts "a lowercase a-tilde (http://en.wikipedia.org/wiki/%C3%83)."
    exit
end

puts "Encoding of argument is reported as #{ARGV[0].encoding} and as #{ARGV[0].valid_encoding? ? "valid" : "invalid"}."
puts "Let us inspect the a-tilde argument: #{ARGV[0].dump}"
puts "Let us inspect the a-tilde from UTF-8 source code transcoded into CP850: #{"ã".encode("CP850").dump}"
puts "Let us inspect the a-tilde from UTF-8 source code transcoded into ISO-8859-1: #{"ã".encode("ISO-8859-1").dump}"
puts "RESULT: as you can see, the argument looks like an ISO-8859-1 string, but reports its encoding as CP850."