# Class: freefilesync
#
# This module manages freefilesync
#
# Parameters: none
#
# Actions:
#
# Requires: see Modulefile
#
# Sample Usage:
#
define freefilesync (
  $source_left = 'c:\documents and settings\User\My Documents\SIL',
  $dest_right  = '\\one\d$\BackupLanguage\undefined',
  $log_dir     = 'c:\temp',
  $config_file = 'c:/documents and settings/one/My Documents/BackupLanguage.ffs_batch') {
  file { "${source_left}.ffs_installer":
    path   => 'c:\temp\FreeFileSync_5.18_Windows_Setup.exe',
    source => "puppet:///modules/freefilesync/FreeFileSync_5.18_Windows_Setup.exe",
    ensure => file,
    mode   => 777,
    notify => Package["${source_left}.install_ffs"],
  }

  package { "${source_left}.install_ffs":
    ensure          => present,
    source          => 'c:\temp\FreeFileSync_5.18_Windows_Setup.exe',
    install_options => ['/S'],
    provider        => windows,
  }

  file { "${source_left}": ensure => directory, }

  file { "${source_left}.config":
    ensure  => file,
    path    => "$config_file",
    content => template('freefilesync/ffs_batch.erb'),
    require => Package["${source_left}.install_ffs"],
  }

  scheduled_task { "${source_left}":
    require   => File["${source_left}.config"],
    command   => "c:\\program files\\FreeFileSync\\FreeFileSync.exe",
    #arguments => "$config_file",
    #ensure    => present,
    #enabled   => true,
    #user      => 'one',
    #password  => '1',
    #trigger   => {
    #  schedule   => 'daily',
    #  start_time => '09:30',
    #}
  }

}
