require 'openssl'
OK_CERT=<<EOF
-----BEGIN CERTIFICATE-----
MIIDqDCCApCgAwIBAgIJAP7c4wEPyUj/MA0GCSqGSIb3DQEBBQUAMDQxCzAJBgNV
BAYTAkZSMRIwEAYDVQQKDAlEaGlteW90aXMxETAPBgNVBAMMCENlcnRpZ25hMB4X
DTA3MDYyOTE1MTMwNVoXDTI3MDYyOTE1MTMwNVowNDELMAkGA1UEBhMCRlIxEjAQ
BgNVBAoMCURoaW15b3RpczERMA8GA1UEAwwIQ2VydGlnbmEwggEiMA0GCSqGSIb3
DQEBAQUAA4IBDwAwggEKAoIBAQDIaPHJ1tazNHUmgh7stL7qXOEm7RFHYeGifBZ4
QCHkYJ5ayGPhxLGWkv8YbWkj4Sti993iNi+RB7lIzw7sebYs5zRLcAglozyHGxny
gQcPOJAZ0xH+hrTy0V4eHpbNgGzOOzGTtvKg0KmVEn2lmsxryIRWijOp5yIVUxbw
zBfsV1/pogqYCd7jX5xv3EjjhQsVWqa6n6xI4wmy9/Qy3l40vhx4XUJbzg4ij02Q
130yGLMLLGq/jj8UEYkgDncUtT2UCIf3JR7VsmAA7G8qKCVuKj4YYxclPz5EIBb2
JsglrgVKtOdjLPOMFlN+XPsRGgjBRmKfIrjxwo1p3Po6WAbfAgMBAAGjgbwwgbkw
DwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUGu3+QTmQtCRZvgHyUtVF9lo53BEw
ZAYDVR0jBF0wW4AUGu3+QTmQtCRZvgHyUtVF9lo53BGhOKQ2MDQxCzAJBgNVBAYT
AkZSMRIwEAYDVQQKDAlEaGlteW90aXMxETAPBgNVBAMMCENlcnRpZ25hggkA/tzj
AQ/JSP8wDgYDVR0PAQH/BAQDAgEGMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG
9w0BAQUFAAOCAQEAhQMeknH2Qq/ho2Ge6/PAD/Kl1NqV5ta+aDY9fm4fTIrv0Q8h
bV6lUmPOEvjvKtpv6zf+EwLHyzs+ImvaYS5/1HI93TDhHkxAGYwP15zRgzB7mFnc
fca5DClMoTOi62c6ZYTTluLtdkVwj7Ur3vkj1kluPBS1xp81HlDQwY9qcEQCYsuu
HWhBp6pX6FOqB9IG9tUUBguRA3UsbHK1YZWaDYu5Def131TN3ubY1gkIl2PlwS6w
t0QmwCbAr1UwnjvVNioZBPRcHv/PLLf/0P2HQBHVESO7SMAhqaQoLf0V+LBOK/Qw
WyH8EZE0vkHve52Xdf+XlcCWWC/qu0bXu+TZLg==
-----END CERTIFICATE-----
EOF

TROUBLE_CERT=<<EOF
-----BEGIN CERTIFICATE-----
MIIFhDCCA2ygAwIBAgIEGZ34eDANBgkqhkiG9w0BAQUFADBlMQswCQYDVQQGEwJD
TjEqMCgGA1UEChMhV29TaWduIGVDb21tZXJjZSBTZXJ2aWNlcyBMaW1pdGVkMSow
KAYDVQQDEyFDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSBvZiBXb1NpZ24wGhcLMDkw
ODA4MDEwMFoXCzI0MDgwODAxMDBaMF8xCzAJBgNVBAYTAkNOMSowKAYDVQQKEyFX
b1NpZ24gZUNvbW1lcmNlIFNlcnZpY2VzIExpbWl0ZWQxJDAiBgNVBAMTG1dvU2ln
biBDbGFzcyAzIE9WIFNlcnZlciBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC
AQoCggEBALyJvmFRU8grlnWzWtMONP5Kwp+jGIOirOMuXpN5CxNJXpOyj4QQ7ZGP
grqtZ98zG66E8lWwW/SznrzmBA8d7wRaqAvsEm1WGWRwSQ9XkvNfIaZNtNKWKzwy
s++PWQsUum6innHb8og/KDvszr5HrEXHip76YZPFSRe2Rrb3mRaMHG4xrmnO7cYk
knChy5bDbBbQ7sxPhjOzQeY9PdsOjDN0u8P8C6f80XHiwQzU97o+gJDUSOuig3DY
2zAHKYn5gSEs/+tH9nptQ5ZnFz7z4nNRx3Ye6Ryg7BEasc8eLZxV7jvGLa7cZmWR
omacrILxpBe110ODw4igZN7KckXcOPsCAwEAAaOCAUQwggFAMBIGA1UdEwEB/wQI
MAYBAf8CAQAwDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBRiLoHZ40J5FKPN2VSK
bvjelaqPmDAfBgNVHSMEGDAWgBThZs8O0fGzS7cGIBT+hxLV9v77PjBjBggrBgEF
BQcBAQRXMFUwJQYIKwYBBQUHMAGGGWh0dHA6Ly9vY3NwLndvc2lnbi5jb20vY2Ew
LAYIKwYBBQUHMAKGIGh0dHA6Ly9haWEud29zaWduLmNvbS93b3NpZ24uY2VyMC4G
A1UdHwQnMCUwI6AhoB+GHWh0dHA6Ly9jcmxzLndvc2lnbi5jb20vY2EuY3JsMEUG
A1UdIAQ+MDwwOgYLKwYBBAGCm1EBAQAwKzApBggrBgEFBQcCARYdaHR0cDovL3d3
dy53b3NpZ24uY29tL3BvbGljeS8wDQYJKoZIhvcNAQEFBQADggIBADJ0W6AuSYNd
K1VEcVF9MEubDGroV4eZ5Lpk3yjLKVls7NaSkmC7C6lIFxjzt5yIDfx3Q4Dklu4c
Fj1RqbDXZ/UKeEzcMo1NWH1qhCJZ1hDJSJEcuuBQj/fM+H7L4T/pgSeZNo/d8GgN
PkYWKpyA8V2zaFkEeJqkFZkVNub0j9N9HKUx3Z7eHoGATMBoxbsTRj1Z9Tcx14Kn
K7aHJ0frHUgCqU99roC0/0Tlc7qla5H/PZzU0iWp6rIjvDsJsFFxwIFppleLPtK4
Bs3Ggq12vxF7V2hjcka6+U6FNULigwc8DgK+qoxjrsGJziNXX3mHGFNxFWlGXKoK
DRJPG1hcL/sw60t+MWGAiKdEdexKQLn9/SaeNcroXJ79/CZyV+KHGCXOBDkND2n6
5TOGnYMxjBK44iZKCRRP3DHeK58SJVmL0wK6XNkgxnJFuHwMWiYvEIH0qE+SdyHA
tv3RPTJfvPYW1Tmw1r8SrNJWBpUtVEneIydsNGcsM2T7r7cjvyfd795HmrEizRzI
v9a22yXkpc9iDg3oujumANNoVWZduAW9z4D055lqFm4h8XnY5bclVb0XVKn4Nzxa
CUz953Ga2R2DsM3MUFZrr54URyN56GdC9UQBuM1SWf53T0MAFdg60TToSdy/GyMc
3j2MXP7WCHav4dl5dXDC7iKN+1TEcSLX
-----END CERTIFICATE-----
EOF

def perform_cert( cert )
  #
  # Show that openSSL can read cert and display starting date
  #
  puts `echo "#{cert}" | openssl x509 -noout -text`
  #
  # Now create a cert with same data, not_before will throw
  # an exception and fail on the TROUBLE_CERT
  c = OpenSSL::X509::Certificate.new(cert)
  puts c.not_before
  puts "-----------------------"
end

  perform_cert(OK_CERT)
  perform_cert(TROUBLE_CERT)
