
ruby_src = <<'ENDSRC'
def xform_kw(op, sexp)
  kw = sexp[0]
  val = case kw
  when "false" then false
  when "true"  then true
  when "nil"   then nil
  else raise("xform_kw: unhandled keyword: #{kw.inspect}")
  end
  [:lit, val]
end
ENDSRC

RubyVM::InstructionSequence.load(RubyVM::InstructionSequence.compile(ruby_src).to_a).eval

xforms = method(:xform_kw)

1000000.times do
  y = xforms.call(:@kw, ["false", [1, 4]])
end

# RubyVM::InstructionSequence.load crash issue.
#
# REFERENCE: https://bugs.ruby-lang.org/issues/8543

# NOTE: In our more complex program, simply calling xform_kw once (on
# a fairly deep stack frame) was sufficient to trigger the crash.
#
# In this stripped-down form, many more iterations seem to be needed.
#
# Calling through the bound method in <xforms> seems to be a
# requirement.  We have not seen the crash when calling xform_kw
# directly.
#
# In other words, both the case statement in xform_kw, as well as
# the bound method call seem to be required.

# We have been able to reproduce the crash on multiple platforms:
#
# ruby 2.2.3p158 (2015-08-12 revision 48555) [i386-mswin32_100]
# ruby 2.2.3p158 (2015-08-12 revision 51190) [i386-darwin13]

# Sometimes, instead of crashing, an exception will be thrown, indicating
# some form of corrpution affecting the program logic:
#
#  <compiled>:7:in `xform_kw': xform_kw: unhandled keyword: "false" (RuntimeError)
#
# However, usually the Ruby VM crashes with a SEGV:
#
# <compiled>:3: [BUG] Segmentation fault at 0xd7cd8d82
# ruby 2.2.3p158 (2015-08-12 revision 51190) [i386-darwin13]
# 
# -- Crash Report log information --------------------------------------------
# See Crash Report log file under the one of following:
# * ~/Library/Logs/CrashReporter
# * /Library/Logs/CrashReporter
# * ~/Library/Logs/DiagnosticReports
# * /Library/Logs/DiagnosticReports
# for more details.
# 
# -- Control frame information -----------------------------------------------
# c:0006 p:0019 s:0025 e:000023 METHOD <compiled>:3 [FINISH]
# c:0005 p:---- s:0017 e:000016 CFUNC :call
# c:0004 p:0016 s:0012 e:000011 BLOCK iseq-load-test5.rb:21 [FINISH]
# c:0003 p:---- s:0009 e:000008 CFUNC  :times
# c:0002 p:0052 s:0006 E:00154c EVAL   iseq-load-test5.rb:19 [FINISH]
# c:0001 p:0000 s:0002 E:002484 TOP    [FINISH]
# 
# -- Ruby level backtrace information ----------------------------------------
# iseq-load-test5.rb:19:in `<main>'
# iseq-load-test5.rb:19:in `times'
# iseq-load-test5.rb:21:in `block in <main>'
# iseq-load-test5.rb:21:in `call'
# <compiled>:3:in `xform_kw'
# 
# -- Machine register context ------------------------------------------------
#  eax: 0xd7cd8d7e ebx: 0x80313a50 ecx: 0x80313a50 edx: 0x0027f754 edi: 0x00000015
#  esi: 0x7cd90f20 ebp: 0xbfeffd38 esp: 0xbfeffd10  ss: 0x00000023 efl: 0x00010282
#  eip: 0x00221b84  cs: 0x0000001b  ds: 0x00000023  es: 0x00000023  fs: 0x00000000
#   gs: 0x0000000f
# 
# -- Other runtime information -----------------------------------------------
# 
# * Loaded script: iseq-load-test5.rb
# 
# * Loaded features:
# 
#     0 enumerator.so
#     1 rational.so
#     2 complex.so
#     3 /Volumes/.../pmruby/lib/ruby/2.2.0/i386-darwin13/enc/encdb.bundle
#     4 /Volumes/.../pmruby/lib/ruby/2.2.0/i386-darwin13/enc/trans/transdb.bundle
#     5 /Volumes/.../pmruby/lib/ruby/2.2.0/unicode_normalize.rb
#     6 /Volumes/.../pmruby/lib/ruby/2.2.0/i386-darwin13/rbconfig.rb
#     7 thread.rb
#     8 /Volumes/.../pmruby/lib/ruby/2.2.0/i386-darwin13/thread.bundle
#     9 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/compatibility.rb
#    10 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/defaults.rb
#    11 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/deprecate.rb
#    12 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/errors.rb
#    13 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/version.rb
#    14 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/requirement.rb
#    15 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/platform.rb
#    16 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/basic_specification.rb
#    17 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/stub_specification.rb
#    18 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/util/stringio.rb
#    19 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/specification.rb
#    20 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/exceptions.rb
#    21 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/core_ext/kernel_gem.rb
#    22 /Volumes/.../pmruby/lib/ruby/2.2.0/monitor.rb
#    23 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems/core_ext/kernel_require.rb
#    24 /Volumes/.../pmruby/lib/ruby/2.2.0/rubygems.rb
# 
# [NOTE]
# You may have encountered a bug in the Ruby interpreter or extension libraries.
# Bug reports are welcome.
# Don't forget to include the above Crash Report log file.
# For details: http://www.ruby-lang.org/bugreport.html
# 
# Abort trap: 6

