#!/usr/local/ruby192/bin/ruby

require 'yaml'

class Integer
    # Compute self ^ e mod m
    def mod_exp e, m
        result = 1
        b = self
        while e > 0
            result = (result * b) % m if e[0] == 1
            e = e >> 1
            b = (b * b) % m
        end
        return result
    end

    # A roundabout, slow but fun way of counting bits.
    def bits_set
        ("%b" % self).count('1')
    end
end

def valid e
    e and e.between?(2, self.p-2) and e.bits_set > 1
end

yaml = YAML.load_file("#{ENV['HOME']}/dhtest.yaml")

P  = yaml['P']
G  = yaml['G']
Q  = yaml['Q']

CX = yaml['CX']
SX = yaml['SX']

CE = yaml['CE']
SE = yaml['SE']

CS = yaml['CS']
SS = yaml['SS']

#c.generate
#s.generate
#
CE2 = G.mod_exp(CX, P)
SE2 = G.mod_exp(SX, P)

ce_ok = CE == CE2
se_ok = SE == SE2

puts "CE #{CE2}"
puts
puts "SE #{SE2}"
puts
puts "CE_OK #{ce_ok} SE_OK #{se_ok}"
puts

#kc = c.secret(s.e)
#ks = s.secret(c.e)
#
CS2 = SE2.mod_exp(CX, P)
SS2 = CE2.mod_exp(SX, P)

cs_ok = CS == CS2
ss_ok = SS == SS2

puts "CS #{CS2}"
puts
puts "SS #{SS2}"
puts
puts "CS_OK #{cs_ok} SS_OK #{ss_ok}"
puts

dh_ok = CS2.to_s == SS2.to_s

if dh_ok
    puts "result: OK"
    exit 0
else
    puts "result: BAD"
    exit 1
end
