require 'net/imap'
require 'rubygems'
require 'ruby-debug'

Net::IMAP.debug = true

class EmailFetcher
  def self.start
    $fetcher_thread = Thread.new do
      conn = Net::IMAP.new("imap.gmail.com", {:port => 993, :ssl => true})
      conn.login("john.doe@gmail.com", "password")
      conn.select("INBOX")

      $receiver_thread = conn.instance_variable_get(:@receiver_thread)

      loop do
        conn.idle do |response|
          if response.kind_of?(Net::IMAP::UntaggedResponse) && response.name == 'EXISTS'
            puts "Some emails arrived!"
            conn.idle_done
          end
        end

        puts "Processing new emails"
      end
    end

  end
end

EmailFetcher.start
$main_thread = Thread.current

loop do
  puts "Threads " + Thread.list.join(", ")
  puts "\tMain thread: #{$main_thread}, status #{$main_thread.status}"
  puts "\tFetcher thread: #{$fetcher_thread}, status #{$fetcher_thread.status}" if $fetcher_thread
  puts "\tReceiver thread: #{$receiver_thread}, status #{$receiver_thread.status}" if $receiver_thread
  puts "\n"

  sleep(10)
end