require "monitor"

class Test
  include MonitorMixin

  def initialize
    mon_initialize
    @cond = new_cond
    @flag = false
    @thread = nil
  end

  attr_reader :flag

  def start
    @thread = Thread.start do
      synchronize do
        while true
          @cond.wait_until{ @flag }
          @flag = false
          begin
            while true
              Process.wait
            end
          rescue Errno::ECHILD
          end
        end
      end
    end
  end

  def set_signal_handler
    Signal.trap(:CHLD) do
      synchronize do
        @flag = true
        @cond.signal
      end
    end
  end
end

o = Test.new
o.set_signal_handler
o.start

while true
  1000.times do
    Process.spawn("ls > /dev/null")
  end
  sleep 1
  p o.flag
end

