require 'socket'
require 'tempfile'
host = '127.0.0.1'
port = 8080
rd, wr = IO.pipe

tmp = Tempfile.new 'big'
tmp.sysseek(1024 * 1024 * 100)
tmp.syswrite("\0")

srv = fork do
  rd.close
  begin
    s = TCPServer.new host, port
    wr.syswrite 'ready'
    c = s.accept
    IO.copy_stream(tmp, c, nil, 0)
  rescue => err
    p [ :srv_err, err ]
  end
end

wr.close
p [ :client, rd.sysread(5) ]
cl = TCPSocket.new host, port
sleep 3 # wait for IO.copy_stream to start

# this should get IO.copy_stream to raise an exception:
cl.close

Process.waitall
