#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <stdio.h>

int main (int argc, const char * argv[]) {
  /*
    result on 10.6.4

    host\serv   | "80"   "0"    ""    NULL
    ------------+---------------------------
    "localhost" |  OK    NG(!)  OK    OK
    ""          |  OK    OK     NG    NG
    NULL        |  OK    OK     NG    NG

    (!) I think it should be OK
   */

  test_addrinfo("localhost", "80");
  test_addrinfo("", "80");
  test_addrinfo(NULL, "80");

  test_addrinfo("localhost", "0");
  test_addrinfo("", "0");
  test_addrinfo(NULL, "0");

  test_addrinfo("localhost", "");
  test_addrinfo("", "");
  test_addrinfo(NULL, "");

  test_addrinfo("localhost", NULL);
  test_addrinfo("", NULL);
  test_addrinfo(NULL, NULL);

  return 0;
}

int test_addrinfo(const char *host, const char *serv) {
  struct addrinfo hints;
  struct addrinfo *res;
  int error;

  memset(&hints, 0, sizeof(hints));
  hints.ai_socktype = SOCK_STREAM;
  hints.ai_family = AF_INET;
  if (serv && strlen(serv) > 0) {
    hints.ai_flags |= AI_NUMERICSERV;
  }

  error = getaddrinfo(host, serv, &hints, &res);
  if (error) {
     printf("[NG]host: %10s, serv: %10s, \n\terror: %s\n", host, serv, gai_strerror(error));
  } else {
     printf("[OK]host: %10s, serv: %10s\n", host, serv);
  }

  freeaddrinfo(res);
}

