require 'tempfile'
require 'benchmark'

Benchmark.bm(27) do |bm|
  [["short", "hoge", 50000],
   ["long ", "Hello world!  " * 1000, 1000]].each do |type, str, max|

    f = Tempfile.new('temp-read')
    f.write str
    f.close

    ["r", "r:us-ascii:utf-8", "r:us-ascii:utf-16le",
     "rb", "rb:us-ascii:utf-8", "rb:us-ascii:utf-16le"].each do |mode|
      open(f.path, mode) do |r|
        bm.report("#{type} #{mode}") do
          max.times do
            r.seek 0
            r.read
          end
        end
      end
    end
  end
end
