$:.unshift "."

require 'BatchProcessor'

def test_fileIO
  # First parameter should be larger than the number of CPU cores.
  doRun(3, 2000) do
    fname = "test#{$$}.txt"
    f = File.new(fname, 'w')
    0.upto(10000) do |i|
      f.puts "#{i} Hello, world! "
    end
    f.close
    File.delete(fname)

    # Allow some time for the OS to recycle file descriptors.
    sleep(0.05)
  end
end

def doRun(maxCPUs, jobs, &block)
  # Create a BatchProcessor
  bp = TaskJuggler::BatchProcessor.new(maxCPUs)

  # Queue jobs
  jobs.times do |i|
    bp.queue("job #{i}") { yield }
  end

  ok = error = 0

  # Wait for them to finish
  bp.wait do |j|
    if j.retVal.signaled?
      error += 1
    else
      ok += 1
    end
  end
  puts "Ok: #{ok}  Errors: #{error}"
end

test_fileIO
