#!/usr/bin/env ruby

require 'socket'
require 'iosyssocket' # Adds IO::syssocket(), IO::sysclose()

include Socket::Constants

FIN = proc { |id| puts "Finalizing an IO::for_fd() object..." }

begin
  #
  # 1. Simulate an extension library which uses sockets internally,
  #    exposing an fd to the ruby layer for for_fd()
  #
  [ IO.syssocket(AF_INET, SOCK_STREAM, 0) ].each do |fd|
    io = IO.for_fd(fd)
    ObjectSpace.define_finalizer(io, FIN)
    #
    # 2. here we'd probably Kernel.select( [io], ... ), etc. ...
    #
    IO.sysclose(fd) # 3. extension library cleans itself up
  end
end

dev_null = File.new("/dev/null") # 4. We re-use the fd our library just closed

p dev_null.stat # 5. Which appears quite normal, until ...
GC.start
p dev_null.stat # 6. ... the IO::for_fd() object finalizer closes it!
                #        Errno::EBADF
