# frozen_string_literal: true

require "launchdarkly-server-sdk"

td = LaunchDarkly::Integrations::TestData.data_source
td.update(td.flag('sample-feature').variation_for_all(true))

ld_logger = Logger.new($stdout)
ld_logger.level = Logger::INFO
ld_config = LaunchDarkly::Config.new({ logger: ld_logger, data_source: td, send_events: false })
@client = LaunchDarkly::LDClient.new('this-does-not-matter', ld_config)

# Process.warmup

context_hash = {
  key: 'anonymous',
  kind: 'user',
  anonymous: true
}

@context = LaunchDarkly::LDContext.create(context_hash)

puts @client.variation('sample-feature', @context, false).inspect
