# This example takes a `date_available` (imagine a product or service that is available on a certain date.)
# If it is `nil`, it prints `Never`.
# If it is available today or earlier, it prints `Now`.
# If it is available in the future, it prints the date it will be available.

require 'date'

date_available = Date.today # Available now

display = case date_available
          when nil then 'Never'
          when ..Date.today then 'Now'
          else
            date_available.to_s
          end

puts display

# ruby 3.1.3p185 (2022-11-24 revision 1a6b16756e) [arm64-darwin22]
# => Now

# ruby 3.2.2 (2023-03-30 revision e51014f9c0) [arm64-darwin22]
# => range_test.rb:7:in `===': cannot determine inclusion in beginless/endless ranges (TypeError)

# ruby 3.3.0dev (2023-09-04T18:01:33Z master db3b814cb0) [arm64-darwin22]
# => range_test.rb:7:in `===': cannot determine inclusion in beginless/endless ranges (TypeError)
