require "bundler/inline"

gemfile do
  gem "graphql", github: "rmosolgo/graphql-ruby", ref: "fiber_scheduler-compat"
  gem "async"
end

class MySchema < GraphQL::Schema
  class Query < GraphQL::Schema::Object
    field :value, Float

    def value
      duration = [0.1, 0.3, 0.5].sample
      system("sleep #{duration}")
      duration
    end
  end

  query(Query)
  use GraphQL::Dataloader, nonblocking: true, fiber_control_mode: :transfer
end

start = Time.now
puts "Starting..."
Fiber.set_scheduler(Async::Scheduler.new)
pp MySchema.execute("{ v1: value v2: value }").to_h
puts "Ended"
pp [:duration, Time.now - start]
