#!/bin/bash

set -e

INSTALL_DIR=$(mktemp -d)
echo "Installing in ${INSTALL_DIR}"

cd "${INSTALL_DIR}"
curl -LO https://github.com/jemalloc/jemalloc/releases/download/5.3.0/jemalloc-5.3.0.tar.bz2
echo '2db82d1e7119df3e71b7640219b6dfe84789bc0537983c3b7ac4f7189aecfeaa *jemalloc-5.3.0.tar.bz2' | shasum -a 256 -c
tar -xf jemalloc-5.3.0.tar.bz2
cd jemalloc-5.3.0
./configure --prefix="${INSTALL_DIR}" --with-rpath="${INSTALL_DIR}/lib"
make
make install
cd "${INSTALL_DIR}"
curl -LO https://cache.ruby-lang.org/pub/ruby/3.2/ruby-3.2.2.tar.xz
echo '4b352d0f7ec384e332e3e44cdbfdcd5ff2d594af3c8296b5636c710975149e23 *ruby-3.2.2.tar.xz' | shasum -a 256 -c
tar -xf ruby-3.2.2.tar.xz
cd ruby-3.2.2
./configure --enable-shared --prefix=${INSTALL_DIR} --with-opt-dir=${INSTALL_DIR} --with-jemalloc
make
make install
