require 'socket'

class TestTcp
    def initialize &block
        @block=block
    end

    def classify res
        res.map{|ary|
            ary.map{|io|
                name = nil
                instance_variables.each{|var|
                    val = instance_variable_get var
                    name = var if val == io
                }
                name
            }
        }
    end

    PORT = '77777'

    def run

        @pid = fork
        if @pid then
            sleep 1

            @sock = Socket.unix(PORT)

            sleep 1

            fds = [@sock]

            res = classify IO.select fds, fds, fds, 0
            STDERR.puts "select: " + res.inspect

            res = classify IO.select_with_poll fds, fds, fds, fds, 0
            STDERR.puts "poll: " + res.inspect
        else
            @sock = Socket.unix_server_socket(PORT)
            @block.call @sock.accept
        end
    end
end

(TestTcp.new{ exit 0 }).run
(TestTcp.new{ sleep 5 ; exit 0 }).run
