require 'bundler/inline'

gemfile do
  source 'https://rubygems.org'

  gem 'memory_profiler'
end

require 'memory_profiler'

class FooWithPlainParams
  def foo(d, e, f)
    @d = d; @e = e; @f = f
  end
end

class FooWithOptionsHash
  def foo(options = {})
    @d = options[:d]; @e = options[:f]; @f = options[:f]
  end
end

class FooWithKeyword
  def foo(d:, e:, f:)
    @d = d; @e = e; @f = f
  end
end

RUNS = 100

puts 'FooWithPlainParams'
f = FooWithPlainParams.new
MemoryProfiler.report do
  RUNS.times do
    f.foo(4,5,6)
  end
end.pretty_print

puts 'FooWithOptionsHash'

f = FooWithOptionsHash.new
MemoryProfiler.report do
  RUNS.times do
    f.foo(d: 4, e: 5, f: 6)
  end
end.pretty_print

puts 'FooWithKeyword'
f = FooWithKeyword.new
MemoryProfiler.report do
  RUNS.times do
    f.foo(d: 4, e: 5, f: 6)
  end
end.pretty_print
