require "benchmark"

ITERATIONS = 1_000_000
STRING = "the quick brown fox jumps over the lazy dog"
SEPERATOR = "fox" # or /fox/

Benchmark.bm(16) do |benchmark|
  benchmark.report("String#before") do
    ITERATIONS.times do
      head = STRING.before(SEPERATOR)
    end
  end

  benchmark.report("String#partition") do
    ITERATIONS.times do
      head, _seperator, _tail = STRING.partition(SEPERATOR)
    end
  end
end

Benchmark.bm(16) do |benchmark|
  benchmark.report("String#after") do
    ITERATIONS.times do
      tail = STRING.after(SEPERATOR)
    end
  end

  benchmark.report("String#partition") do
    ITERATIONS.times do
      _head, _seperator, tail = STRING.partition(SEPERATOR)
    end
  end
end
