require 'csv'
require 'date'

#######################################
# Success
counter = 0

CSV.foreach('./05-31-20.CSV') do |row|
  time = row[0]
  next unless time.to_s.match?(/^[0-9]{4}/)

  DateTime.strptime(time, '%Y-%m-%dT%H:%M:%S.%L %Z')
  counter += 1
end

p "Success: #{counter} lines"

#######################################
# Fail
counter = 0

CSV.foreach('./05-31-20.CSV', skip_lines: /^[^0-9]{4}/) do |row|
  time = row[0]

  p time if time.length < 23
  counter += 1
end

p "FAIL: #{counter} lines"
