#!/bin/bash
set -euxo pipefail

apt-get update && apt-get upgrade && apt-get install -y --no-install-recommends \
    bzip2 \
    ca-certificates \
    libffi-dev \
    libgdbm3 \
    libssl-dev \
    libyaml-dev \
    procps \
    zlib1g-dev \
    libjemalloc-dev

mkdir -p /usr/local/etc \
  && { \
    echo 'install: --no-document'; \
    echo 'update: --no-document'; \
  } >> /usr/local/etc/gemrc

apt-get install -y --no-install-recommends \
    autoconf \
    bison \
    dpkg-dev \
    gcc \
    libbz2-dev \
    libgdbm-dev \
    libglib2.0-dev \
    libncurses-dev \
    libreadline-dev \
    libxml2-dev \
    libxslt-dev \
    make \
    ruby \
    wget \
    xz-utils

function build_ruby {
  RUBY_MAJOR=$1
  RUBY_VERSION=$2
  RUBY_DOWNLOAD_SHA256=$3

  wget -O ruby.tar.xz "https://cache.ruby-lang.org/pub/ruby/${RUBY_MAJOR%-rc}/ruby-$RUBY_VERSION.tar.xz" \
  && echo "$RUBY_DOWNLOAD_SHA256 *ruby.tar.xz" | sha256sum -c - \
  && mkdir -p "/usr/src/ruby-${RUBY_MAJOR}" \
  && tar -xJf ruby.tar.xz -C "/usr/src/ruby-${RUBY_MAJOR}" --strip-components=1 \
  && rm ruby.tar.xz \
  && cd "/usr/src/ruby-${RUBY_MAJOR}" \
  && autoconf \
  && gnuArch="$(dpkg-architecture --query DEB_BUILD_GNU_TYPE)" \
  && ./configure \
    --build="$gnuArch" \
    --disable-install-doc \
    --enable-shared \
    --with-jemalloc \
  && make -j "$(nproc)" \
  && make install \
  && dpkg-query --show --showformat '${package}\n' \
    | grep -P '^libreadline\d+$' \
    | xargs apt-mark manual \
  && apt-get purge -y --auto-remove \
    autoconf \
    bison \
    dpkg-dev \
    gcc \
    libbz2-dev \
    libgdbm-dev \
    libglib2.0-dev \
    libncurses-dev \
    libreadline-dev \
    libxml2-dev \
    libxslt-dev \
    make \
    ruby \
    wget \
    xz-utils
}


# Comment out one of the lines to install the version you want:
#build_ruby "2.5" "2.5.3" "1cc9d0359a8ea35fc6111ec830d12e60168f3b9b305a3c2578357d360fcf306f"
#build_ruby "2.6" "2.6.0" "acb00f04374899ba8ee74bbbcb9b35c5c6b1fd229f1876554ee76f0f1710ff5f"

