#!/usr/bin/env ruby

require 'benchmark/ips'
require 'set'

n_values1 = 200
n_values2 = (n_values1 * 0.8).to_i
overlap = (n_values2 * 0.5).to_i

a1 = (0...n_values1).to_a
a2 = ((n_values1 - overlap)...(n_values1 - overlap + n_values2)).to_a
s1 = Set.new(a1)
s2 = Set.new(a2)
ss1 = SortedSet.new(a1)
ss2 = SortedSet.new(a2)

puts RUBY_VERSION
puts s1.size
puts s2.size
puts((s1 & s2).size)

methods = {
  Set_Set: -> { s2 & s1 },
  Set_SortedSet: -> { s2 & ss1 },
  SortedSet_Set: -> { ss2 & s1 },
  SortedSet_SortedSet: -> { ss2 & ss1 },
  Set_Array: -> { s2 & a1 },
}

Benchmark.ips do |bm|
  methods.each do |name, method|
    bm.report(name) { method.call }
  end
end
