require 'net/http'

def timed_block(title, &block)
  puts "-" * title.length
  puts title
  puts "-" * title.length

  start_time = Time.now
  yield
  end_time = Time.now

  puts
  puts "Time taken: #{end_time - start_time}"
  puts
end

def socket_open?(http)
  socket = http.instance_variable_get(:@socket)

  socket ? !socket.closed? : false
end

timed_block("Using #start") do
  Net::HTTP.start('httpbin.org', port=443, use_ssl: true) { |http|
    10.times {
      http.get("/")
      socket = http.instance_variable_get(:@socket)
      puts "Connection Alive? #{socket_open?(http).inspect}"
    }
  }
end

timed_block("Using #new") do
  http = Net::HTTP.new('httpbin.org', 443)
  http.use_ssl = true
  10.times {
    http.get("/")
    socket = http.instance_variable_get(:@socket)
    puts "Connection Alive? #{socket_open?(http).inspect}"
  }
end

timed_block("Using #new with a call to #start") do
  http = Net::HTTP.new('httpbin.org', 443)
  http.use_ssl = true
  http.start # This forces a connection to be opened
  10.times {
    http.get("/")
    socket = http.instance_variable_get(:@socket)
    puts "Connection Alive? #{socket_open?(http).inspect}"
  }
end
