require "set"
require "benchmark"

set1 = Set[*(0..1000).to_a]
set2 = Set[*(0..1000).to_a]

sset1 = SortedSet[*(0..1000).to_a]
sset2 = SortedSet[*(0..1000).to_a]

puts "Without patch:"
puts ""
puts "Set#== with Set:             #{Benchmark.measure { 300.times { set1 == set2 } }}"
puts "Set#== with SortedSet:       #{Benchmark.measure { 300.times { set1 == sset1 } }}"
puts "SortedSet#== with SortedSet: #{Benchmark.measure { 300.times { sset1 == sset2 } }}"

class Set
  def ==(other)
    if self.equal?(other)
      true
    elsif other.instance_of?(self.class)
      @hash == other.instance_variable_get(:@hash)
    elsif other.is_a?(Set) && self.size == other.size
      other.all? { |o| @hash.include?(o) }
    else
      false
    end
  end
end

puts ""
puts "With patch:"
puts ""
puts "Set#== with Set:             #{Benchmark.measure { 300.times { set1 == set2 } }}"
puts "Set#== with SortedSet:       #{Benchmark.measure { 300.times { set1 == sset1 } }}"
puts "SortedSet#== with SortedSet: #{Benchmark.measure { 300.times { sset1 == sset2 } }}"