# frozen_string_literal: true

module SegFault

  def handle_module(module_var, module_name, ns_var = nil, from = 'Unkwn')

    namespace = ns_var ?
      ( namespace = namespaces[ns_var] || create_core(ns_var) ||
        namespace_for_variable(ns_var) ) : Registry.root

    if namespace.nil?
      raise(Parser::UndocumentableError, "module #{module_name}. Cannot find definition for parent namespace.")
    end

    obj = nil if obj && obj.namespace != namespace

    if obj
      case obj
      when Proxy
        ::YardT2.lg("mod #{from} proxy", namespace.path, module_name, module_var, ns_var)
      when ModuleObject
        namespace = namespaces[module_var] = obj unless namespaces[module_var]
        obj.add_file(statement.file, statement.line)
        if ::YardT2::D_NS[1] == 1
          ::YardT2.lg("mod  exists #{from} ", namespace.path, module_name, module_var, ns_var)
        end
        obj
        return
      when ClassObject
        if ::YardT2::D_NS[1] == 1
          ::YardT2.lg("mod  Class? #{from} ", namespace.path, module_name, module_var, ns_var)
        end
        namespace = namespaces[module_var] = obj unless namespaces[module_var]
        obj
      end
    end

    obj = ModuleObject.new(namespace, module_name)  do |obj|
      register_file_info(obj, statement.file, statement.line)
    end

  end

end
