require_relative 'readline'

PROMPT = "rltest$ "

$running = true
$sigwinch_received = false

Readline.handler_install(PROMPT, add_hist: true) do |line|
	# Can use ^D (stty eof) or `exit' to exit.
	if !line || line == "exit"
		puts unless line
		puts "exit"
		Readline.handler_remove
		$running = false
	else
		puts "input line: #{line}"
	end
end

Signal.trap('SIGWINCH') { $sigwinch_received = true }

while $running do
	rs = IO.select([$stdin])
	if $sigwinch_received
		Readline.resize_terminal
		$sigwinch_received = false
	end
	Readline.read_char if r = rs[0]
end

puts "rltest: Event loop has exited"
