require "base64"
require "openssl"

puts "Ruby Version = #{RUBY_VERSION}"
[:VERSION, :OPENSSL_LIBRARY_VERSION, :OPENSSL_VERSION].each do |const|
  puts "OpenSSL::#{const} = #{OpenSSL.const_get(const)}"
end
puts "\n"

csr = OpenSSL::X509::Request.new

begin
  OpenSSL::X509::Request.new(csr.to_der)
  puts "Successfully re-imported CSR from DER format."
rescue => e
  puts "ERROR: Failed to re-import CSR from DER format (#{e.message})."
ensure
  puts "Base64 DER:"
  puts Base64.strict_encode64(csr.to_der)
end
puts "\n"

begin
  OpenSSL::X509::Request.new(csr.to_pem)
  puts "Successfully re-imported CSR from PEM format"
rescue => e
  puts "ERROR: Failed to re-import CSR in PEM format (#{e.message})."
ensure
  puts "PEM:"
  puts csr.to_pem
end
