#! /usr/bin/env ruby

require 'csv'
require 'benchmark/ips'

Tempfile.create(["", ".csv"]) do |f|
  head = [*'aa'..'zz']
  f.puts head.to_a.join(',')
  1000.times do
    f.puts [*1..head.length].map{ |i| %("#{i}") }.join(',')
  end
  f.flush

  Benchmark.ips do |x|
    x.report("old_csv_shift") do
      load './old_csv_shift.rb'
      CSV.open(f.path) do |csv|
        csv.each {}
      end
    end
    x.report("new_csv_shift") do
      load './new_csv_shift.rb'
      CSV.open(f.path) do |csv|
        csv.each {}
      end
    end
    x.compare!
  end
end
