# This code always raises error at line 54 in my environment.
# But the code may complete without erro accoding to environment.
require 'webrick'
require 'webrick/https'
require 'webrick/httpproxy'
require 'net/https'

PROXY_PORT = 8088
ORIGIN_PORT = 8043
RESPONSE_BODY = "_" * 1_000_000 # response body that may be bigger than socket buffer


# Setup proxy server
proxy = WEBrick::HTTPProxyServer.new({
  :Port => PROXY_PORT,
})

proxy_thread = Thread.new { proxy.start }
at_exit { proxy.shutdown }


# Setup origin server
origin = WEBrick::HTTPServer.new({
  :Port         => ORIGIN_PORT,
  :SSLEnable    => true,
  :SSLCertName  => [["CN", "devserver"]],
})

origin.mount_proc("/") do |req, res|
  res.body = RESPONSE_BODY
end

origin_thread = Thread.new { origin.start }
at_exit { origin.shutdown }


# Send request
http = Net::HTTP.new("localhost", ORIGIN_PORT, "localhost", PROXY_PORT)
http.use_ssl = true
http.verify_mode = OpenSSL::SSL::VERIFY_NONE

http.start do |http|
  req = Net::HTTP::Get.new("/")

  http.request(req) do |response|
    n = 0

    response.read_body do |chunk|
      n += chunk.length
      sleep 0.1
    end

    unless RESPONSE_BODY.length == n
      raise "Response body is stripped (expects #{RESPONSE_BODY.length}, but #{n})"
    end
  end
end
