class Prime
  def self.nth(num)
    error(num)
    primes = build_primes(num)
    primes.last
  end

  private

  def build_primes(num)
    primes = [2]
    index  = 3 
    until primes.size == num
      if example?(index, primes)
        primes << index
      end
      index += 1
    end
    primes
  end

  def error(num)
    unless num > 0
      raise ArgumentError
    end
  end

  def example?(index, primes)
    primes.each do |prime|
      if index % prime == 0
        return false
      end
    end
    true
  end
end
