require 'webrick'

servers = []
threads = []

10.times {|i|
	threads << Thread.new {
	begin
		root = File.expand_path('D:/Test')
		server = WEBrick::HTTPServer.new({
			:DocumentRoot => root,
			:Port => 8000+i,
			:MaxClients => 20,
			:RequestTimeout => 60,
			:DoNotReverseLookup => true,
			:AccessLog => []
		})

		server.mount_proc('/') {|req, res|
			res.body = 'Hello, world!'
			100.times {|i| res.body << ' ' }
		}

		servers << server
		server.start
	rescue Exception
		puts("Woops: #{$!.to_s}")
		retry
	end
	}
}

threads.each {|t| t.join }

