module SummaryStats
  class AggregateTxService
    class AggregateMasterCardPayment
      def input
        TxMasterCardPayment.order(:appeared_at)
      end

      def aggregate?(a, b)
        a.appeared_at.to_date == b.appeared_at.to_date
      end

      def aggregate(chunks)
        data = DataHash.new {{
          "count" => 0,
          "amount" => BigDecimal(0)
        }}

        chunks.each do |c|
          data.set(c.kind, c.currency) { |x|
            x["count"] += 1
            x["amount"] += c.amount
          }
        end

        [chunks.first.appeared_at.to_date, data.h]
      end

      def output(ary)
        Logging.quiet_active_record_log do
          AggregatedMasterCardPayment.delete_all
          AggregatedMasterCardPayment.import [:for_date, :data], ary, validate: false
        end
      end

      def perform
        Logging.log_execution_time self.class.name.demodulize.underscore do
          AggregationService.new(
            input:      self.input,
            aggregator: self,
            output:     -> (ary) { self.output ary }
          ).perform
        end
      end
    end
  end
end
