require 'openssl'
$stderr.sync = true
require 'socket'
host = '127.0.0.1'
TEST_KEY_DH1024 = OpenSSL::PKey::DH.new <<-_end_of_pem_
-----BEGIN DH PARAMETERS-----
MIGHAoGBAKnKQ8MNK6nYZzLrrcuTsLxuiJGXoOO5gT+tljOTbHBuiktdMTITzIY0
pFxIvjG05D7HoBZQfrR0c92NGWPkAiCkhQKB8JCbPVzwNLDy6DZ0pmofDKrEsYHG
AQjjxMXhwULlmuR/K+WwlaZPiLIBYalLAZQ7ZbOPeVkJ8ePao0eLAgEC
-----END DH PARAMETERS-----
_end_of_pem_

TEST_KEY_DH1024.priv_key = OpenSSL::BN.new("48561834C67E65FFD2A9B47F41" \
   "E5E78FDC95C387428FDB1E4B0188B64D1643C3A8D3455B945B7E8C4D166010C7C2" \
   "CE23BFB9BEF43D0348FE7FA5284B0225E7FE1537546D114E3D8A4411B9B9351AB4" \
   "51E1A358F50ED61B1F00DA29336EEBBD649980AC86D76AF8BBB065298C2052672E" \
   "EF3EF13AB47A15275FC2836F3AC74CEA", 16)

def ssl_client(host, port)
  ctx = OpenSSL::SSL::SSLContext.new
  ctx.set_params
  ctx.ciphers = "ADH"
  s = TCPSocket.new(host, port)
  ssl = OpenSSL::SSL::SSLSocket.new(s, ctx)
  ssl.connect
  ssl.sync_close = true
  ssl
end

def srv_ctx
  ctx = OpenSSL::SSL::SSLContext.new
  ctx.set_params
  ctx.ciphers = "ADH"
  ctx.tmp_dh_callback = proc { TEST_KEY_DH1024 }
  ctx
end

serv = TCPServer.new(host, 0)
port = serv.addr[1]
clients = []
accepted = []
pid = fork do
  ssl_ctx = srv_ctx
  buf = ""
  begin
    a = serv.accept
    ssl = OpenSSL::SSL::SSLSocket.new(a, ssl_ctx)
    ssl.accept
    ssl.readpartial(11, buf)
    ssl.write "HI".freeze
    ssl.flush
    accepted << ssl
  rescue => e
    warn "#$$: #{e.message} (#{e.class})"
    warn "#$$: accepted: #{accepted.size}"
    sleep
  end while true
end
serv.close

buf = ""
begin
  c = ssl_client(host, port)
  c.write "HELLO".freeze
  c.flush
  c.readpartial(11, buf)
  clients << c
rescue => e
  warn "#$$: #{e.message} (#{e.class})"
  warn "#$$: clients: #{clients.size}"
  sleep
end while true
