require 'zlib'

def test_string len
	puts "generating len=#{len} string..."
	source = %w(a b c d e f g h i j k l m n o p q r s t u v w x y z
	      A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
	      0 1 2 3 4 5 6 7 8 9 ! @ # $ % ^ & * [ ] )
	base = (0..999).map{ source[rand(72)] }.join
	str = base * (len / base.length)
	puts "string length=#{str.length}"

	puts "compressing..."
	data = Zlib::Deflate.deflate(str)

	puts "decompressing..."
	str2 = Zlib::Inflate.inflate(data)

	puts (str == str2)
end

puts Process.pid
Signal.trap("INT") { puts "INT" }
Signal.trap("TERM") { puts "TERM" }

[ 1000000000 ].each { |len| test_string len }
