require_relative 'iseqtest'

def run_file(filename)
	# Compile instructions
	data = RubyVM::InstructionSequence.compile_file(filename)
	str = Marshal.dump(data.to_a)
	# Execute instructions
	run_iseq(data.to_a)
end

['test1.rb', 'test2.rb', 'test3.rb'].each do |filename|
	begin
		run_file(filename)
	rescue TypeError
		puts "#{filename}: EXCEPTION"
		puts $!
		puts "----------------------"
	else
		puts "#{filename}: OK"
	end
end
