require 'test/unit'

class TestTracepointWithDomainName < Test::Unit::TestCase
  def setup
    require 'domain_name'
  end

  def test_tracepoint_with_domain_name_gem
    events = []
  
    tracepoint = TracePoint.new(:call, :return) do |tp|
      events << [ tp.event, tp.method_id]
    end
  
    tracepoint.enable { DomainName.new('google.com') }
  
    expected_events = [ [:call, :initialize],
                        [:call, :normalize],
                        [:call, :to_nfc],
                        [:return, :to_nfc],
                        [:call, :encode_hostname],
                        [:return, :encode_hostname],
                        [:return, :normalize],
                        [:call, :etld_data],
                        [:return, :etld_data],
                        [:return, :initialize]
                      ]

    assert_equal expected_events, events
  end
end
