require 'benchmark'

def old_benchmark
  r0 = Time.now
  yield
  Time.now - r0
end

def new_benchmark
  r0 = Process.clock_gettime(Process::CLOCK_MONOTONIC)
  yield
  Process.clock_gettime(Process::CLOCK_MONOTONIC) - r0
end

n = (ARGV.first || 1_000_000).to_i

puts "#{n} iterations."

Benchmark.bmbm do |b|
  b.report("old") { n.times { old_benchmark { nil } } }
  b.report("new") { n.times { new_benchmark { nil } } }
end
